#ifdef GL_ES
    precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform float u_time; // Added uniform for time-based animation

void main() {
    // Base texture color
    vec4 baseColor = texture2D(u_texture, v_texCoords) * v_color;
    
    // Vignette effect
    float vignette = 1.0 - dot(v_texCoords - 0.5, v_texCoords - 0.5) * 0.65;
    vignette = clamp(vignette, 0.3, 1.0);
    
    // Glitch effect parameters
    float glitchStrength = 0.01; // Controls intensity of glitch offset
    float glitchFrequency = 0.05; // Controls how often glitches occur
    float time = u_time * 0.35; // Slow down time for smoother animation
    
    // RGB channel splitting
    vec2 redOffset = vec2(glitchStrength * sin(time + v_texCoords.y * 5.0), 0.0);
    vec2 greenOffset = vec2(glitchStrength * cos(time + v_texCoords.y * 9.5), 0.0);
    vec2 blueOffset = vec2(-glitchStrength * sin(time + v_texCoords.y * 2.7), 0.0);
    
    // Sample texture with offset for each channel
    float red = texture2D(u_texture, v_texCoords + redOffset).r;
    float green = texture2D(u_texture, v_texCoords + greenOffset).g;
    float blue = texture2D(u_texture, v_texCoords + blueOffset).b;
    
    // Random scanline noise
    float noise = fract(sin(dot(v_texCoords + time, vec2(12.9898, 78.233))) * 43758.5453);
    float scanlineGlitch = step(0.89, sin(v_texCoords.y * 200.0 + time) + noise * glitchFrequency);
    vec3 glitchColor = vec3(red, green, blue) + scanlineGlitch * 0.075; // Subtle noise intensity
    
    // Combine effects
    vec4 finalColor = vec4(mix(baseColor.rgb, glitchColor, 0.3), baseColor.a); // Blend glitch with base
    finalColor.rgb *= vignette;
    finalColor.a = 1.0;

    gl_FragColor = finalColor;
}